const fileInput = document.querySelector("#upload");

const originalImage = document.querySelector("#originalImage");
const compressedImage = document.querySelector("#compressedImage");

const resizingElement = document.querySelector("#resizingRange");
const qualityElement = document.querySelector("#qualityRange");

const uploadButton = document.querySelector("#uploadButton");

let compressedImageBlob;

let resizingFactor = 0.8;
let quality = 0.5;

// initializing the compressed image
compressImage(originalImage, resizingFactor, quality);
convertImage(originalImage);

fileInput.addEventListener("change", async (e) => {
  const [file] = fileInput.files;
  // storing the original image
  originalImage.src = await fileToDataUri(file);

  // compressing the uplodaded image
  originalImage.addEventListener("load", () => {
    compressImage(originalImage, resizingFactor, quality);
  });

  return false;
});

resizingElement.oninput = (e) => {
  resizingFactor = parseInt(e.target.value) / 100;
  compressImage(originalImage, resizingFactor, quality);
};

qualityElement.oninput = (e) => {
  quality = parseInt(e.target.value) / 100;
  compressImage(originalImage, resizingFactor, quality);
};

uploadButton.onclick = () => {
  // uploading the compressed image to
  // Imgur (if present)
  if (compressedImageBlob) {
    const formdata = new FormData();
    formdata.append("image", compressedImageBlob);

    console.log(formdata)
  } else {
    alert("Rezind and compressed image missing!");
  }
};

function convertImage(imgToConvert) {

    const image = new Image();
    image.onload = () => {

        const canvas = document.createElement('canvas');
        canvas.width = image.naturalWidth;
        canvas.height = image.naturalHeight;
        canvas.getContext('2d').drawImage(image, 0, 0);
        canvas.toBlob((blob) => {
            
            // Now we have a `blob` containing webp data

            // Use the file rename trick to turn it back into a file
            const myImage = new File([blob], 'my-new-name.webp', { type: blob.type });

        }, 'image/webp');

    };

    image.src = URL.createObjectURL(myFile);
}

function compressImage(imgToCompress, resizingFactor, quality) {
  // showing the compressed image
  const canvas = document.createElement("canvas");
  const context = canvas.getContext("2d");

  const originalWidth = imgToCompress.width;
  const originalHeight = imgToCompress.height;

  const canvasWidth = originalWidth * resizingFactor;
  const canvasHeight = originalHeight * resizingFactor;

  canvas.width = canvasWidth;
  canvas.height = canvasHeight;

  context.drawImage(
    imgToCompress,
    0,
    0,
    originalWidth * resizingFactor,
    originalHeight * resizingFactor
  );

  // reducing the quality of the image
  canvas.toBlob(
    (blob) => {
      if (blob) {
        compressedImageBlob = blob;
        compressedImage.src = URL.createObjectURL(compressedImageBlob);
        document.querySelector("#size-compression").innerHTML = bytesToSize(blob.size);
      }
    },
    "image/jpeg",
    quality
  );
}

function fileToDataUri(field) {
  return new Promise((resolve) => {
    const reader = new FileReader();
    reader.addEventListener("load", () => {
      resolve(reader.result);
    });
    reader.readAsDataURL(field);
  });
}

// source: https://stackoverflow.com/a/18650828
function bytesToSize(bytes) {
  const sizes = ["Bytes", "KB", "MB", "GB", "TB"];

  if (bytes === 0) {
    return "0 Byte";
  }

  const i = parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));

  return Math.round(bytes / Math.pow(1024, i), 2) + " " + sizes[i];
}

